#ifndef GRAPH_HPP
#define GRAPH_HPP

#include <iostream>
#include <vector>

typedef unsigned int NodeId;
typedef unsigned int EdgeId;
typedef long long    Capacity;
typedef long long    Flow;

class Graph
{
public:

   class Node
   {
      public:
         void add_incoming(EdgeId edge);
         void add_outgoing(EdgeId edge);

         std::vector<EdgeId> const & in_edges() const;
         std::vector<EdgeId> const & out_edges() const;

         std::vector<EdgeId> & in_edges();
         std::vector<EdgeId> & out_edges();

      private:
         std::vector<EdgeId> incoming_;
         std::vector<EdgeId> outgoing_;
   };

   class Edge
   {
      public:
         Edge();
         Edge(NodeId tail, NodeId head, Capacity cap, EdgeId edge_number);

         NodeId   tail() const;
         NodeId   head() const;
         Capacity cap() const;
         Flow     flow() const;
         EdgeId   edge_id() const;
         void     set_flow(Flow flow);

      private:
         NodeId   tail_;
         NodeId   head_;
         Capacity cap_;
         Flow     flow_;
         EdgeId   edge_id_;
   };

   Graph(NodeId nodes);
   Graph();

   void add_edge(NodeId tail, NodeId head, Capacity cap, EdgeId edge_number);
   void add_edge(Edge const & edge);
   NodeId add_node();

   NodeId num_nodes() const;
   EdgeId num_edges() const;
   Node & node(NodeId node);
   Edge & edge(EdgeId edge);

   static const EdgeId invalid_edge;
   static const NodeId invalid_node;

   void pra(bool mode, NodeId s, NodeId t);

private:

   void print();
   void push(EdgeId edgeid, bool res);
   void relabel(NodeId nodeid);

   void add_flow(EdgeId edgeid, Flow flow);

   std::vector<unsigned int> psi;
   std::vector<Flow>         ex;

   std::vector<Node> nodes;
   std::vector<Edge> edges;
};

std::ostream & operator<<(std::ostream & os, Graph::Edge const & edge);
std::ostream & operator<<(std::ostream & os, Graph::Node const & node);

#endif
